<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


namespace Eccube\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * NewsRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class NewsRepository extends EntityRepository
{

    /**
     * News の順位を1上げる.
     *
     * @param  \Eccube\Entity\News $News
     * @return boolean 成功した場合 true
     */
    public function up(\Eccube\Entity\News $News)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $News->getRank();

            $News2 = $this->findOneBy(array('rank' => $rank + 1));
            if (!$News2) {
                throw new \Exception();
            }
            $News2->setRank($rank);
            $em->persist($News2);

            // News更新
            $News->setRank($rank + 1);

            $em->persist($News);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }

    /**
     * News の順位を1下げる
     *
     * @param  \Eccube\Entity\News $News
     * @return boolean 成功した場合 true
     */
    public function down(\Eccube\Entity\News $News)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $News->getRank();
            $News2 = $this->findOneBy(array('rank' => $rank - 1));
            if (!$News2) {
                throw new \Exception();
            }
            $News2->setRank($rank);
            $em->persist($News2);

            // News更新
            $News->setRank($rank - 1);

            $em->persist($News);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }

    /**
     * News を保存する.
     *
     * @param  \Eccube\Entity\News $News
     * @return boolean 成功した場合 true
     */
    public function save(\Eccube\Entity\News $News)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            if (!$News->getId()) {
                $rank = $this->createQueryBuilder('n')
                ->select('MAX(n.rank)')
                ->getQuery()
                ->getSingleScalarResult();
                if (!$rank) {
                    $rank = 0;
                }
                $News
                    ->setRank($rank + 1)
                    ->setDelFlg(0);
            }

            $em->persist($News);
            $em->flush();
            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();
            return false;
        }

        return true;
    }

    /**
     * News を削除する.
     *
     * @param  \Eccube\Entity\News $News
     * @return boolean 成功した場合 true
     */
    public function delete(\Eccube\Entity\News $News)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $News->getRank();
            $em->createQueryBuilder()
            ->update('Eccube\Entity\News', 'n')
            ->set('n.rank', 'n.rank - 1')
            ->where('n.rank > :rank')->setParameter('rank', $rank)
            ->getQuery()
            ->execute();

            $News
                ->setDelFlg(1)
                ->setRank(0);

            $em->persist($News);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();
            return false;
        }

        return true;
    }
}
