COMMENT ON TABLE dtb_csv IS 'CSV情報';
COMMENT ON COLUMN dtb_csv.no IS '番号';
COMMENT ON COLUMN dtb_csv.csv_id IS 'CSVマスタ種別ID';
COMMENT ON COLUMN dtb_csv.col IS 'カラム名';
COMMENT ON COLUMN dtb_csv.disp_name IS '表示名';
COMMENT ON COLUMN dtb_csv.rank IS '表示順';
COMMENT ON COLUMN dtb_csv.status IS '状態';
COMMENT ON COLUMN dtb_csv.create_date IS '作成日時';
COMMENT ON COLUMN dtb_csv.update_date IS '更新日時';
COMMENT ON COLUMN dtb_csv.mb_convert_kana_option IS 'mb_convert_kana オプション';
COMMENT ON COLUMN dtb_csv.size_const_type IS '文字長タイプ';
COMMENT ON COLUMN dtb_csv.error_check_types IS 'エラーチェックタイプ';
COMMENT ON COLUMN dtb_csv.rw_flg IS '読み書きフラグ';

COMMENT ON TABLE dtb_csv_sql IS 'CSV詳細設定SQL情報';
COMMENT ON COLUMN dtb_csv_sql.sql_id IS 'SQLID';
COMMENT ON COLUMN dtb_csv_sql.sql_name IS 'SQL名';
COMMENT ON COLUMN dtb_csv_sql.csv_sql IS 'SQL詳細';
COMMENT ON COLUMN dtb_csv_sql.update_date IS '更新日時';
COMMENT ON COLUMN dtb_csv_sql.create_date IS '作成日時';

COMMENT ON TABLE mtb_recommend IS 'おすすめレベル';
COMMENT ON COLUMN mtb_recommend.id IS 'ID';
COMMENT ON COLUMN mtb_recommend.name IS '名称';
COMMENT ON COLUMN mtb_recommend.rank IS '表示順';

COMMENT ON TABLE dtb_best_products IS 'おすすめ商品情報';
COMMENT ON COLUMN dtb_best_products.best_id IS 'ベスト商品ID';
COMMENT ON COLUMN dtb_best_products.category_id IS 'カテゴリID';
COMMENT ON COLUMN dtb_best_products.product_id IS '商品ID';
COMMENT ON COLUMN dtb_best_products.rank IS '表示順';
COMMENT ON COLUMN dtb_best_products.title IS 'タイトル';
COMMENT ON COLUMN dtb_best_products.comment IS 'コメント';
COMMENT ON COLUMN dtb_best_products.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_best_products.create_date IS '作成日時';
COMMENT ON COLUMN dtb_best_products.update_date IS '更新日時';
COMMENT ON COLUMN dtb_best_products.del_flg IS '削除フラグ';

COMMENT ON TABLE dtb_customer_favorite_products IS 'お気に入り商品情報';
COMMENT ON COLUMN dtb_customer_favorite_products.product_id IS '商品ID';
COMMENT ON COLUMN dtb_customer_favorite_products.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_customer_favorite_products.create_date IS '作成日時';
COMMENT ON COLUMN dtb_customer_favorite_products.update_date IS '更新日時';

COMMENT ON TABLE dtb_other_deliv IS 'その他の配送先情報';
COMMENT ON COLUMN dtb_other_deliv.other_deliv_id IS 'その他の配送先ID';
COMMENT ON COLUMN dtb_other_deliv.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_other_deliv.name01 IS '姓';
COMMENT ON COLUMN dtb_other_deliv.name02 IS '名';
COMMENT ON COLUMN dtb_other_deliv.kana01 IS '姓(カナ)';
COMMENT ON COLUMN dtb_other_deliv.kana02 IS '名(カナ)';
COMMENT ON COLUMN dtb_other_deliv.company_name IS '【2.13】会社名';
COMMENT ON COLUMN dtb_other_deliv.zip01 IS '郵便番号(4桁)';
COMMENT ON COLUMN dtb_other_deliv.zip02 IS '郵便番号(3桁)';
COMMENT ON COLUMN dtb_other_deliv.zipcode IS '【2.13】郵便番号(海外対応)';
COMMENT ON COLUMN dtb_other_deliv.country_id IS '【2.13】国ID';
COMMENT ON COLUMN dtb_other_deliv.pref IS '都道府県';
COMMENT ON COLUMN dtb_other_deliv.addr01 IS '市区町村';
COMMENT ON COLUMN dtb_other_deliv.addr02 IS '番地等';
COMMENT ON COLUMN dtb_other_deliv.tel01 IS '電話(市外局番)';
COMMENT ON COLUMN dtb_other_deliv.tel02 IS '電話(市内局番)';
COMMENT ON COLUMN dtb_other_deliv.tel03 IS '電話(局番)';
COMMENT ON COLUMN dtb_other_deliv.fax01 IS 'FAX（市外局番）';
COMMENT ON COLUMN dtb_other_deliv.fax02 IS 'FAX（市内局番）';
COMMENT ON COLUMN dtb_other_deliv.fax03 IS 'FAX（局番）';

COMMENT ON TABLE mtb_ownersstore_err IS 'オーナーズストアエラー種別';
COMMENT ON COLUMN mtb_ownersstore_err.id IS 'ID';
COMMENT ON COLUMN mtb_ownersstore_err.name IS '名称';
COMMENT ON COLUMN mtb_ownersstore_err.rank IS '表示順';

COMMENT ON TABLE dtb_ownersstore_settings IS 'オーナーズストア設定';
COMMENT ON COLUMN dtb_ownersstore_settings.public_key IS '認証キー';

COMMENT ON TABLE dtb_category_total_count IS 'カテゴリ商品合計数情報';
COMMENT ON COLUMN dtb_category_total_count.category_id IS 'カテゴリID';
COMMENT ON COLUMN dtb_category_total_count.product_count IS '商品合計数';
COMMENT ON COLUMN dtb_category_total_count.create_date IS '作成日時';

COMMENT ON TABLE dtb_category_count IS 'カテゴリ商品数情報';
COMMENT ON COLUMN dtb_category_count.category_id IS 'カテゴリID';
COMMENT ON COLUMN dtb_category_count.product_count IS '商品数';
COMMENT ON COLUMN dtb_category_count.create_date IS '作成日時';

COMMENT ON TABLE dtb_category IS 'カテゴリ情報';
COMMENT ON COLUMN dtb_category.category_id IS 'カテゴリID';
COMMENT ON COLUMN dtb_category.category_name IS 'カテゴリ名';
COMMENT ON COLUMN dtb_category.parent_category_id IS '親カテゴリID';
COMMENT ON COLUMN dtb_category.level IS '階層';
COMMENT ON COLUMN dtb_category.rank IS '表示順';
COMMENT ON COLUMN dtb_category.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_category.create_date IS '作成日時';
COMMENT ON COLUMN dtb_category.update_date IS '更新日時';
COMMENT ON COLUMN dtb_category.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_status_image IS 'ステータス画像';
COMMENT ON COLUMN mtb_status_image.id IS 'ID';
COMMENT ON COLUMN mtb_status_image.name IS '名称';
COMMENT ON COLUMN mtb_status_image.rank IS '表示順';

COMMENT ON TABLE dtb_session IS 'セッション情報';
COMMENT ON COLUMN dtb_session.sess_id IS 'セッションID';
COMMENT ON COLUMN dtb_session.sess_data IS 'セッションデータ';
COMMENT ON COLUMN dtb_session.create_date IS '作成日時';
COMMENT ON COLUMN dtb_session.update_date IS '更新日時';

COMMENT ON TABLE dtb_templates IS 'テンプレート情報';
COMMENT ON COLUMN dtb_templates.template_code IS 'テンプレートコード';
COMMENT ON COLUMN dtb_templates.template_name IS 'テンプレート名';
COMMENT ON COLUMN dtb_templates.create_date IS '作成日時';
COMMENT ON COLUMN dtb_templates.update_date IS '更新日時';
COMMENT ON COLUMN dtb_templates.device_type_id IS '端末種別ID';

COMMENT ON TABLE mtb_db IS 'データベース種別';
COMMENT ON COLUMN mtb_db.id IS 'ID';
COMMENT ON COLUMN mtb_db.name IS '名称';
COMMENT ON COLUMN mtb_db.rank IS '表示順';

COMMENT ON TABLE mtb_reminder IS 'パスワード質問マスタ';
COMMENT ON COLUMN mtb_reminder.id IS 'ID';
COMMENT ON COLUMN mtb_reminder.name IS '名称';
COMMENT ON COLUMN mtb_reminder.rank IS '表示順';

COMMENT ON TABLE mtb_target IS 'ブロックターゲット';
COMMENT ON COLUMN mtb_target.id IS 'ID';
COMMENT ON COLUMN mtb_target.name IS '名称';
COMMENT ON COLUMN mtb_target.rank IS '表示順';

COMMENT ON TABLE dtb_bloc IS 'ブロック情報';
COMMENT ON COLUMN dtb_bloc.device_type_id IS '端末種別ID';
COMMENT ON COLUMN dtb_bloc.bloc_id IS 'ブロックID';
COMMENT ON COLUMN dtb_bloc.bloc_name IS 'ブロック名';
COMMENT ON COLUMN dtb_bloc.tpl_path IS 'Smartyテンプレートパス';
COMMENT ON COLUMN dtb_bloc.filename IS 'ファイル名';
COMMENT ON COLUMN dtb_bloc.create_date IS '作成日時';
COMMENT ON COLUMN dtb_bloc.update_date IS '更新日時';
COMMENT ON COLUMN dtb_bloc.php_path IS 'PHPパス';
COMMENT ON COLUMN dtb_bloc.deletable_flg IS '削除可能フラグ';
COMMENT ON COLUMN dtb_bloc.plugin_id IS 'プラグインID';

COMMENT ON TABLE dtb_blocposition IS 'ブロック配置情報';
COMMENT ON COLUMN dtb_blocposition.device_type_id IS '端末種別ID';
COMMENT ON COLUMN dtb_blocposition.page_id IS 'ページID';
COMMENT ON COLUMN dtb_blocposition.target_id IS '配置ID';
COMMENT ON COLUMN dtb_blocposition.bloc_id IS 'ブロックID';
COMMENT ON COLUMN dtb_blocposition.bloc_row IS 'ブロック配置順序';
COMMENT ON COLUMN dtb_blocposition.anywhere IS '全ページに配置するフラグ';

COMMENT ON TABLE dtb_plugin IS 'プラグイン情報';
COMMENT ON COLUMN dtb_plugin.plugin_id IS 'プラグインID';
COMMENT ON COLUMN dtb_plugin.plugin_name IS 'プラグイン名';
COMMENT ON COLUMN dtb_plugin.plugin_code IS 'プラグインコード';
COMMENT ON COLUMN dtb_plugin.author IS '作成者';
COMMENT ON COLUMN dtb_plugin.plugin_site_url IS 'サイトURL';
COMMENT ON COLUMN dtb_plugin.plugin_version IS 'バージョン';
COMMENT ON COLUMN dtb_plugin.plugin_description IS '詳細説明';
COMMENT ON COLUMN dtb_plugin.class_name IS 'クラス名';
COMMENT ON COLUMN dtb_plugin.enable IS '有効';
COMMENT ON COLUMN dtb_plugin.create_date IS '作成日時';
COMMENT ON COLUMN dtb_plugin.update_date IS '更新日時';
COMMENT ON COLUMN dtb_plugin.author_site_url IS '作成者サイトURL';
COMMENT ON COLUMN dtb_plugin.compliant_version IS '本体対応バージョン';
COMMENT ON COLUMN dtb_plugin.priority IS '優先度';
COMMENT ON COLUMN dtb_plugin.free_field1 IS '任意項目１';
COMMENT ON COLUMN dtb_plugin.free_field2 IS '任意項目２';
COMMENT ON COLUMN dtb_plugin.free_field3 IS '任意項目３';
COMMENT ON COLUMN dtb_plugin.free_field4 IS '任意項目４';

COMMENT ON TABLE dtb_pagelayout IS 'ページレイアウト情報';
COMMENT ON COLUMN dtb_pagelayout.device_type_id IS '端末種別ID';
COMMENT ON COLUMN dtb_pagelayout.page_id IS 'ページID';
COMMENT ON COLUMN dtb_pagelayout.page_name IS 'ページ名';
COMMENT ON COLUMN dtb_pagelayout.url IS 'ページURL';
COMMENT ON COLUMN dtb_pagelayout.filename IS 'ファイル名';
COMMENT ON COLUMN dtb_pagelayout.header_chk IS 'ヘッダチェックフラグ';
COMMENT ON COLUMN dtb_pagelayout.footer_chk IS 'フッタチェックフラグ';
COMMENT ON COLUMN dtb_pagelayout.edit_flg IS '修正フラグ';
COMMENT ON COLUMN dtb_pagelayout.author IS 'meta タグ(Author)';
COMMENT ON COLUMN dtb_pagelayout.description IS 'meta タグ(Description)';
COMMENT ON COLUMN dtb_pagelayout.keyword IS 'meta タグ(keyword)';
COMMENT ON COLUMN dtb_pagelayout.meta_robots IS '【2.13】meta タグ(robots)';
COMMENT ON COLUMN dtb_pagelayout.update_url IS '更新実施URL';
COMMENT ON COLUMN dtb_pagelayout.create_date IS '作成日時';
COMMENT ON COLUMN dtb_pagelayout.update_date IS '更新日時';

COMMENT ON TABLE mtb_page_max IS 'ページ最大表示数';
COMMENT ON COLUMN mtb_page_max.id IS 'ID';
COMMENT ON COLUMN mtb_page_max.name IS '名称';
COMMENT ON COLUMN mtb_page_max.rank IS '表示順';

COMMENT ON TABLE dtb_mailmaga_template IS 'メルマガテンプレート情報';
COMMENT ON COLUMN dtb_mailmaga_template.template_id IS 'テンプレートID';
COMMENT ON COLUMN dtb_mailmaga_template.subject IS '件名';
COMMENT ON COLUMN dtb_mailmaga_template.mail_method IS 'メール送信方法';
COMMENT ON COLUMN dtb_mailmaga_template.body IS '本文';
COMMENT ON COLUMN dtb_mailmaga_template.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_mailmaga_template.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_mailmaga_template.create_date IS '作成日時';
COMMENT ON COLUMN dtb_mailmaga_template.update_date IS '更新日時';

COMMENT ON TABLE mtb_magazine_type IS 'メルマガ種別';
COMMENT ON COLUMN mtb_magazine_type.id IS 'ID';
COMMENT ON COLUMN mtb_magazine_type.name IS '名称';
COMMENT ON COLUMN mtb_magazine_type.rank IS '表示順';

COMMENT ON TABLE mtb_mail_template IS 'メールテンプレート';
COMMENT ON COLUMN mtb_mail_template.id IS 'ID';
COMMENT ON COLUMN mtb_mail_template.name IS '名称';
COMMENT ON COLUMN mtb_mail_template.rank IS '表示順';

COMMENT ON TABLE mtb_mail_tpl_path IS 'メールテンプレートパス';
COMMENT ON COLUMN mtb_mail_tpl_path.id IS 'ID';
COMMENT ON COLUMN mtb_mail_tpl_path.name IS '名称';
COMMENT ON COLUMN mtb_mail_tpl_path.rank IS '表示順';

COMMENT ON TABLE dtb_mailtemplate IS 'メールテンプレート情報';
COMMENT ON COLUMN dtb_mailtemplate.template_id IS 'テンプレートID';
COMMENT ON COLUMN dtb_mailtemplate.subject IS '件名';
COMMENT ON COLUMN dtb_mailtemplate.header IS 'ヘッダ';
COMMENT ON COLUMN dtb_mailtemplate.footer IS 'フッタ';
COMMENT ON COLUMN dtb_mailtemplate.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_mailtemplate.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_mailtemplate.create_date IS '作成日時';
COMMENT ON COLUMN dtb_mailtemplate.update_date IS '更新日時';

COMMENT ON TABLE mtb_mail_magazine_type IS 'メールマガジン種別';
COMMENT ON COLUMN mtb_mail_magazine_type.id IS 'ID';
COMMENT ON COLUMN mtb_mail_magazine_type.name IS '名称';
COMMENT ON COLUMN mtb_mail_magazine_type.rank IS '表示順';

COMMENT ON TABLE mtb_mail_type IS 'メール種別';
COMMENT ON COLUMN mtb_mail_type.id IS 'ID';
COMMENT ON COLUMN mtb_mail_type.name IS '名称';
COMMENT ON COLUMN mtb_mail_type.rank IS '表示順';

COMMENT ON TABLE dtb_send_history IS 'メール送信履歴';
COMMENT ON COLUMN dtb_send_history.send_id IS '送信ID';
COMMENT ON COLUMN dtb_send_history.mail_method IS 'メール送信方法';
COMMENT ON COLUMN dtb_send_history.subject IS '件名';
COMMENT ON COLUMN dtb_send_history.body IS '本文';
COMMENT ON COLUMN dtb_send_history.send_count IS '送信数';
COMMENT ON COLUMN dtb_send_history.complete_count IS '送信完了数';
COMMENT ON COLUMN dtb_send_history.start_date IS '送信開始日時';
COMMENT ON COLUMN dtb_send_history.end_date IS '送信完了日時';
COMMENT ON COLUMN dtb_send_history.search_data IS '検索データ';
COMMENT ON COLUMN dtb_send_history.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_send_history.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_send_history.create_date IS '作成日時';
COMMENT ON COLUMN dtb_send_history.update_date IS '更新日時';

COMMENT ON TABLE dtb_module IS 'モジュール情報';
COMMENT ON COLUMN dtb_module.module_id IS 'モジュールID';
COMMENT ON COLUMN dtb_module.module_code IS 'モジュールコード';
COMMENT ON COLUMN dtb_module.module_name IS 'モジュール名';
COMMENT ON COLUMN dtb_module.sub_data IS 'データ';
COMMENT ON COLUMN dtb_module.auto_update_flg IS '自動更新フラグ';
COMMENT ON COLUMN dtb_module.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_module.create_date IS '作成日時';
COMMENT ON COLUMN dtb_module.update_date IS '更新日時';

COMMENT ON TABLE dtb_module_update_logs IS 'モジュール更新ログ情報';
COMMENT ON COLUMN dtb_module_update_logs.log_id IS 'ログID';
COMMENT ON COLUMN dtb_module_update_logs.module_id IS 'モジュールID';
COMMENT ON COLUMN dtb_module_update_logs.buckup_path IS 'バックアップパス';
COMMENT ON COLUMN dtb_module_update_logs.error_flg IS 'エラーフラグ';
COMMENT ON COLUMN dtb_module_update_logs.error IS 'エラーメッセージ';
COMMENT ON COLUMN dtb_module_update_logs.ok IS '正常終了メッセージ';
COMMENT ON COLUMN dtb_module_update_logs.create_date IS '作成日時';
COMMENT ON COLUMN dtb_module_update_logs.update_date IS '更新日時';

COMMENT ON TABLE dtb_update IS 'モジュール更新情報';
COMMENT ON COLUMN dtb_update.module_id IS 'モジュールID';
COMMENT ON COLUMN dtb_update.module_name IS 'モジュール名';
COMMENT ON COLUMN dtb_update.now_version IS 'インストールバージョン';
COMMENT ON COLUMN dtb_update.latest_version IS '最新バージョン';
COMMENT ON COLUMN dtb_update.module_explain IS '機能説明';
COMMENT ON COLUMN dtb_update.main_php IS '更新対象パス';
COMMENT ON COLUMN dtb_update.extern_php IS '拡張対象パス';
COMMENT ON COLUMN dtb_update.install_sql IS 'インストールSQL';
COMMENT ON COLUMN dtb_update.uninstall_sql IS 'アンインストールSQL';
COMMENT ON COLUMN dtb_update.other_files IS 'その他拡張ファイル名';
COMMENT ON COLUMN dtb_update.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_update.create_date IS '作成日時';
COMMENT ON COLUMN dtb_update.update_date IS '更新日時';
COMMENT ON COLUMN dtb_update.release_date IS 'リリース日時';

COMMENT ON TABLE dtb_mobile_ext_session_id IS 'モバイルセッション情報';
COMMENT ON COLUMN dtb_mobile_ext_session_id.session_id IS 'セッションID';
COMMENT ON COLUMN dtb_mobile_ext_session_id.param_key IS 'パラメータキー';
COMMENT ON COLUMN dtb_mobile_ext_session_id.param_value IS 'パラメータ値';
COMMENT ON COLUMN dtb_mobile_ext_session_id.url IS 'URL';
COMMENT ON COLUMN dtb_mobile_ext_session_id.create_date IS '作成日時';

COMMENT ON TABLE mtb_mobile_domain IS 'モバイルドメイン名';
COMMENT ON COLUMN mtb_mobile_domain.id IS 'ID';
COMMENT ON COLUMN mtb_mobile_domain.name IS '名称';
COMMENT ON COLUMN mtb_mobile_domain.rank IS '表示順';

COMMENT ON TABLE dtb_review IS 'レビュー情報';
COMMENT ON COLUMN dtb_review.review_id IS 'レビューID';
COMMENT ON COLUMN dtb_review.product_id IS '商品ID';
COMMENT ON COLUMN dtb_review.reviewer_name IS 'レビューア名';
COMMENT ON COLUMN dtb_review.reviewer_url IS 'レビューアURL';
COMMENT ON COLUMN dtb_review.sex IS '性別';
COMMENT ON COLUMN dtb_review.customer_id IS '顧客lID';
COMMENT ON COLUMN dtb_review.recommend_level IS 'おすすめレベル';
COMMENT ON COLUMN dtb_review.title IS 'タイトル';
COMMENT ON COLUMN dtb_review.comment IS 'コメント';
COMMENT ON COLUMN dtb_review.status IS '状態';
COMMENT ON COLUMN dtb_review.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_review.create_date IS '作成日時';
COMMENT ON COLUMN dtb_review.update_date IS '更新日時';
COMMENT ON COLUMN dtb_review.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_review_deny_url IS 'レビュー拒否URL';
COMMENT ON COLUMN mtb_review_deny_url.id IS 'ID';
COMMENT ON COLUMN mtb_review_deny_url.name IS '名称';
COMMENT ON COLUMN mtb_review_deny_url.rank IS '表示順';

COMMENT ON TABLE mtb_disable_logout IS 'ログアウト無効ページ';
COMMENT ON COLUMN mtb_disable_logout.id IS 'ID';
COMMENT ON COLUMN mtb_disable_logout.name IS '名称';
COMMENT ON COLUMN mtb_disable_logout.rank IS '表示順';

COMMENT ON TABLE dtb_holiday IS '休日情報';
COMMENT ON COLUMN dtb_holiday.holiday_id IS '休日ID';
COMMENT ON COLUMN dtb_holiday.title IS 'タイトル';
COMMENT ON COLUMN dtb_holiday.month IS '月';
COMMENT ON COLUMN dtb_holiday.day IS '日';
COMMENT ON COLUMN dtb_holiday.rank IS '表示順';
COMMENT ON COLUMN dtb_holiday.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_holiday.create_date IS '作成日時';
COMMENT ON COLUMN dtb_holiday.update_date IS '更新日時';
COMMENT ON COLUMN dtb_holiday.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_disp IS '公開フラグ';
COMMENT ON COLUMN mtb_disp.id IS 'ID';
COMMENT ON COLUMN mtb_disp.name IS '名称';
COMMENT ON COLUMN mtb_disp.rank IS '表示順';

COMMENT ON TABLE mtb_order_status_color IS '受注ステータス色';
COMMENT ON COLUMN mtb_order_status_color.id IS 'ID';
COMMENT ON COLUMN mtb_order_status_color.name IS '名称';
COMMENT ON COLUMN mtb_order_status_color.rank IS '表示順';

COMMENT ON TABLE dtb_mail_history IS '受注メール送信履歴';
COMMENT ON COLUMN dtb_mail_history.send_id IS '送信ID';
COMMENT ON COLUMN dtb_mail_history.send_date IS '送信日時';
COMMENT ON COLUMN dtb_mail_history.template_id IS 'テンプレートID';
COMMENT ON COLUMN dtb_mail_history.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_mail_history.subject IS '件名';
COMMENT ON COLUMN dtb_mail_history.mail_body IS 'メール本文';
COMMENT ON COLUMN dtb_mail_history.order_id IS '受注ID';

COMMENT ON TABLE dtb_order_temp IS '受注一時情報';
COMMENT ON COLUMN dtb_order_temp.order_temp_id IS '受注一時情報ID';
COMMENT ON COLUMN dtb_order_temp.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_order_temp.message IS '要望等';
COMMENT ON COLUMN dtb_order_temp.order_name01 IS '顧客名(姓)';
COMMENT ON COLUMN dtb_order_temp.order_name02 IS '顧客名(名)';
COMMENT ON COLUMN dtb_order_temp.order_kana01 IS '顧客カナ(姓)';
COMMENT ON COLUMN dtb_order_temp.order_kana02 IS '顧客カナ(名)';
COMMENT ON COLUMN dtb_order_temp.order_company_name IS '【2.13】会社名';
COMMENT ON COLUMN dtb_order_temp.order_email IS '顧客メールアドレス';
COMMENT ON COLUMN dtb_order_temp.order_tel01 IS '顧客電話番号(市外局番)';
COMMENT ON COLUMN dtb_order_temp.order_tel02 IS '顧客電話番号(市内局番)';
COMMENT ON COLUMN dtb_order_temp.order_tel03 IS '顧客電話番号(局番)';
COMMENT ON COLUMN dtb_order_temp.order_fax01 IS '顧客FAX(市外局番)';
COMMENT ON COLUMN dtb_order_temp.order_fax02 IS '顧客FAX(市内局番)';
COMMENT ON COLUMN dtb_order_temp.order_fax03 IS '顧客FAX(局番)';
COMMENT ON COLUMN dtb_order_temp.order_zip01 IS '顧客郵便番号(4桁)';
COMMENT ON COLUMN dtb_order_temp.order_zip02 IS '顧客郵便番号(3桁)';
COMMENT ON COLUMN dtb_order_temp.order_zipcode IS '【2.13】顧客郵便番号(海外対応)';
COMMENT ON COLUMN dtb_order_temp.order_country_id IS '【2.13】顧客国ID';
COMMENT ON COLUMN dtb_order_temp.order_pref IS '都道府県ID';
COMMENT ON COLUMN dtb_order_temp.order_addr01 IS '顧客住所1';
COMMENT ON COLUMN dtb_order_temp.order_addr02 IS '顧客住所2';
COMMENT ON COLUMN dtb_order_temp.order_sex IS '顧客性別';
COMMENT ON COLUMN dtb_order_temp.order_birth IS '顧客生年月日';
COMMENT ON COLUMN dtb_order_temp.order_job IS '顧客職業';
COMMENT ON COLUMN dtb_order_temp.subtotal IS '小計';
COMMENT ON COLUMN dtb_order_temp.discount IS '値引き';
COMMENT ON COLUMN dtb_order_temp.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_order_temp.deliv_fee IS '送料';
COMMENT ON COLUMN dtb_order_temp.charge IS '手数料';
COMMENT ON COLUMN dtb_order_temp.use_point IS '使用ポイント';
COMMENT ON COLUMN dtb_order_temp.add_point IS '加算ポイント';
COMMENT ON COLUMN dtb_order_temp.birth_point IS 'お誕生日ポイント';
COMMENT ON COLUMN dtb_order_temp.tax IS '税金';
COMMENT ON COLUMN dtb_order_temp.total IS '合計';
COMMENT ON COLUMN dtb_order_temp.payment_total IS '支払い合計';
COMMENT ON COLUMN dtb_order_temp.payment_id IS '支払方法ID';
COMMENT ON COLUMN dtb_order_temp.payment_method IS '支払方法';
COMMENT ON COLUMN dtb_order_temp.note IS '備考';
COMMENT ON COLUMN dtb_order_temp.mail_flag IS 'メルマガ希望フラグ';
COMMENT ON COLUMN dtb_order_temp.status IS '受注状態';
COMMENT ON COLUMN dtb_order_temp.deliv_check IS '属性0';
COMMENT ON COLUMN dtb_order_temp.point_check IS 'ポイント使用フラグ';
COMMENT ON COLUMN dtb_order_temp.create_date IS '作成日時';
COMMENT ON COLUMN dtb_order_temp.update_date IS '更新日時';
COMMENT ON COLUMN dtb_order_temp.device_type_id IS '端末種別ID';
COMMENT ON COLUMN dtb_order_temp.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_order_temp.order_id IS '受注ID';
COMMENT ON COLUMN dtb_order_temp.memo01 IS '汎用項目1';
COMMENT ON COLUMN dtb_order_temp.memo02 IS '汎用項目2';
COMMENT ON COLUMN dtb_order_temp.memo03 IS '汎用項目3';
COMMENT ON COLUMN dtb_order_temp.memo04 IS '汎用項目4';
COMMENT ON COLUMN dtb_order_temp.memo05 IS '汎用項目5';
COMMENT ON COLUMN dtb_order_temp.memo06 IS '汎用項目6';
COMMENT ON COLUMN dtb_order_temp.memo07 IS '汎用項目7';
COMMENT ON COLUMN dtb_order_temp.memo08 IS '汎用項目8';
COMMENT ON COLUMN dtb_order_temp.memo09 IS '汎用項目9';
COMMENT ON COLUMN dtb_order_temp.memo10 IS '汎用項目10';
COMMENT ON COLUMN dtb_order_temp.session IS 'セッション情報';

COMMENT ON TABLE dtb_order IS '受注情報';
COMMENT ON COLUMN dtb_order.order_id IS '受注ID';
COMMENT ON COLUMN dtb_order.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_order.order_temp_id IS '受注一時情報ID';
COMMENT ON COLUMN dtb_order.message IS '要望等';
COMMENT ON COLUMN dtb_order.order_name01 IS '顧客名(姓)';
COMMENT ON COLUMN dtb_order.order_name02 IS '顧客名(名)';
COMMENT ON COLUMN dtb_order.order_kana01 IS '顧客カナ(姓)';
COMMENT ON COLUMN dtb_order.order_kana02 IS '顧客カナ(名)';
COMMENT ON COLUMN dtb_order.order_company_name IS '【2.13】会社名';
COMMENT ON COLUMN dtb_order.order_email IS '顧客メールアドレス';
COMMENT ON COLUMN dtb_order.order_tel01 IS '顧客電話番号(市外局番)';
COMMENT ON COLUMN dtb_order.order_tel02 IS '顧客電話番号(市内局番)';
COMMENT ON COLUMN dtb_order.order_tel03 IS '顧客電話番号(局番)';
COMMENT ON COLUMN dtb_order.order_fax01 IS '顧客FAX(市外局番)';
COMMENT ON COLUMN dtb_order.order_fax02 IS '顧客FAX(市内局番)';
COMMENT ON COLUMN dtb_order.order_fax03 IS '顧客FAX(局番)';
COMMENT ON COLUMN dtb_order.order_zip01 IS '顧客郵便番号(4桁)';
COMMENT ON COLUMN dtb_order.order_zip02 IS '顧客郵便番号(3桁)';
COMMENT ON COLUMN dtb_order.order_zipcode IS '【2.13】顧客郵便番号(海外対応)';
COMMENT ON COLUMN dtb_order.order_country_id IS '【2.13】顧客国ID';
COMMENT ON COLUMN dtb_order.order_pref IS '都道府県ID';
COMMENT ON COLUMN dtb_order.order_addr01 IS '顧客住所1';
COMMENT ON COLUMN dtb_order.order_addr02 IS '顧客住所2';
COMMENT ON COLUMN dtb_order.order_sex IS '顧客性別';
COMMENT ON COLUMN dtb_order.order_birth IS '顧客生年月日';
COMMENT ON COLUMN dtb_order.order_job IS '顧客職業';
COMMENT ON COLUMN dtb_order.subtotal IS '小計';
COMMENT ON COLUMN dtb_order.discount IS '値引き';
COMMENT ON COLUMN dtb_order.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_order.deliv_fee IS '送料';
COMMENT ON COLUMN dtb_order.charge IS '手数料';
COMMENT ON COLUMN dtb_order.use_point IS '使用ポイント';
COMMENT ON COLUMN dtb_order.add_point IS '加算ポイント';
COMMENT ON COLUMN dtb_order.birth_point IS 'お誕生日ポイント';
COMMENT ON COLUMN dtb_order.tax IS '税金';
COMMENT ON COLUMN dtb_order.total IS '合計';
COMMENT ON COLUMN dtb_order.payment_total IS '支払い合計';
COMMENT ON COLUMN dtb_order.payment_id IS '支払方法ID';
COMMENT ON COLUMN dtb_order.payment_method IS '支払方法';
COMMENT ON COLUMN dtb_order.note IS '備考';
COMMENT ON COLUMN dtb_order.status IS '受注状態';
COMMENT ON COLUMN dtb_order.create_date IS '作成日時';
COMMENT ON COLUMN dtb_order.update_date IS '更新日時';
COMMENT ON COLUMN dtb_order.payment_date IS '入金日時';
COMMENT ON COLUMN dtb_order.commit_date IS '発送済み日時';
COMMENT ON COLUMN dtb_order.device_type_id IS '端末種別ID';
COMMENT ON COLUMN dtb_order.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_order.memo01 IS '汎用項目1';
COMMENT ON COLUMN dtb_order.memo02 IS '汎用項目2';
COMMENT ON COLUMN dtb_order.memo03 IS '汎用項目3';
COMMENT ON COLUMN dtb_order.memo04 IS '汎用項目4';
COMMENT ON COLUMN dtb_order.memo05 IS '汎用項目5';
COMMENT ON COLUMN dtb_order.memo06 IS '汎用項目6';
COMMENT ON COLUMN dtb_order.memo07 IS '汎用項目7';
COMMENT ON COLUMN dtb_order.memo08 IS '汎用項目8';
COMMENT ON COLUMN dtb_order.memo09 IS '汎用項目9';
COMMENT ON COLUMN dtb_order.memo10 IS '汎用項目10';

COMMENT ON TABLE mtb_order_status IS '受注状態';
COMMENT ON COLUMN mtb_order_status.id IS 'ID';
COMMENT ON COLUMN mtb_order_status.name IS '名称';
COMMENT ON COLUMN mtb_order_status.rank IS '表示順';

COMMENT ON TABLE dtb_order_detail IS '受注詳細情報';
COMMENT ON COLUMN dtb_order_detail.order_detail_id IS '受注詳細ID';
COMMENT ON COLUMN dtb_order_detail.order_id IS '受注ID';
COMMENT ON COLUMN dtb_order_detail.product_id IS '商品ID';
COMMENT ON COLUMN dtb_order_detail.product_class_id IS '商品規格ID';
COMMENT ON COLUMN dtb_order_detail.product_name IS '商品名';
COMMENT ON COLUMN dtb_order_detail.product_code IS '商品コード';
COMMENT ON COLUMN dtb_order_detail.classcategory_name1 IS '商品規格名1';
COMMENT ON COLUMN dtb_order_detail.classcategory_name2 IS '商品規格名2';
COMMENT ON COLUMN dtb_order_detail.price IS '価格';
COMMENT ON COLUMN dtb_order_detail.quantity IS '個数';
COMMENT ON COLUMN dtb_order_detail.point_rate IS 'ポイント付与率';
COMMENT ON COLUMN dtb_order_detail.tax_rate IS '【2.13】消費税率';
COMMENT ON COLUMN dtb_order_detail.tax_rule IS '【2.13】課税規則';

COMMENT ON TABLE dtb_product_categories IS '商品カテゴリ関連';
COMMENT ON COLUMN dtb_product_categories.category_id IS 'カテゴリID';
COMMENT ON COLUMN dtb_product_categories.product_id IS '商品ID';
COMMENT ON COLUMN dtb_product_categories.rank IS '表示順';

COMMENT ON TABLE mtb_status IS '商品ステータス';
COMMENT ON COLUMN mtb_status.id IS 'ID';
COMMENT ON COLUMN mtb_status.name IS '名称';
COMMENT ON COLUMN mtb_status.rank IS '表示順';

COMMENT ON TABLE dtb_product_status IS '商品ステータス情報';
COMMENT ON COLUMN dtb_product_status.product_id IS '商品ID';
COMMENT ON COLUMN dtb_product_status.product_status_id IS '商品ステータスID';
COMMENT ON COLUMN dtb_product_status.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_product_status.create_date IS '作成日時';
COMMENT ON COLUMN dtb_product_status.update_date IS '更新日時';
COMMENT ON COLUMN dtb_product_status.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_product_status_color IS '商品ステータス色';
COMMENT ON COLUMN mtb_product_status_color.id IS 'ID';
COMMENT ON COLUMN mtb_product_status_color.name IS '名称';
COMMENT ON COLUMN mtb_product_status_color.rank IS '表示順';

COMMENT ON TABLE mtb_product_list_max IS '商品一覧最大表示数';
COMMENT ON COLUMN mtb_product_list_max.id IS 'ID';
COMMENT ON COLUMN mtb_product_list_max.name IS '名称';
COMMENT ON COLUMN mtb_product_list_max.rank IS '表示順';

COMMENT ON TABLE dtb_products IS '商品情報';
COMMENT ON COLUMN dtb_products.product_id IS '商品ID';
COMMENT ON COLUMN dtb_products.name IS '商品名';
COMMENT ON COLUMN dtb_products.maker_id IS 'メーカーID';
COMMENT ON COLUMN dtb_products.status IS '表示ステータス';
COMMENT ON COLUMN dtb_products.comment1 IS 'コメント1(メーカーURL)';
COMMENT ON COLUMN dtb_products.comment2 IS 'コメント2';
COMMENT ON COLUMN dtb_products.comment3 IS 'コメント3(検索ワード)';
COMMENT ON COLUMN dtb_products.comment4 IS 'コメント4';
COMMENT ON COLUMN dtb_products.comment5 IS 'コメント5';
COMMENT ON COLUMN dtb_products.comment6 IS 'コメント6';
COMMENT ON COLUMN dtb_products.note IS '備考';
COMMENT ON COLUMN dtb_products.main_list_comment IS 'メイン一覧コメント';
COMMENT ON COLUMN dtb_products.main_list_image IS 'メイン一覧画像';
COMMENT ON COLUMN dtb_products.main_comment IS 'メインコメント';
COMMENT ON COLUMN dtb_products.main_image IS 'メイン画像';
COMMENT ON COLUMN dtb_products.main_large_image IS 'メイン拡大画像';
COMMENT ON COLUMN dtb_products.sub_title1 IS 'サブタイトル1';
COMMENT ON COLUMN dtb_products.sub_comment1 IS 'サブコメント1';
COMMENT ON COLUMN dtb_products.sub_image1 IS 'サブ画像1';
COMMENT ON COLUMN dtb_products.sub_large_image1 IS 'サブ拡大画像1';
COMMENT ON COLUMN dtb_products.sub_title2 IS 'サブタイトル2';
COMMENT ON COLUMN dtb_products.sub_comment2 IS 'サブコメント2';
COMMENT ON COLUMN dtb_products.sub_image2 IS 'サブ画像2';
COMMENT ON COLUMN dtb_products.sub_large_image2 IS 'サブ拡大画像2';
COMMENT ON COLUMN dtb_products.sub_title3 IS 'サブタイトル3';
COMMENT ON COLUMN dtb_products.sub_comment3 IS 'サブコメント3';
COMMENT ON COLUMN dtb_products.sub_image3 IS 'サブ画像3';
COMMENT ON COLUMN dtb_products.sub_large_image3 IS 'サブ拡大画像3';
COMMENT ON COLUMN dtb_products.sub_title4 IS 'サブタイトル4';
COMMENT ON COLUMN dtb_products.sub_comment4 IS 'サブコメント4';
COMMENT ON COLUMN dtb_products.sub_image4 IS 'サブ画像4';
COMMENT ON COLUMN dtb_products.sub_large_image4 IS 'サブ拡大画像4';
COMMENT ON COLUMN dtb_products.sub_title5 IS 'サブタイトル5';
COMMENT ON COLUMN dtb_products.sub_comment5 IS 'サブコメント5';
COMMENT ON COLUMN dtb_products.sub_image5 IS 'サブ画像5';
COMMENT ON COLUMN dtb_products.sub_large_image5 IS 'サブ拡大画像5';
COMMENT ON COLUMN dtb_products.sub_title6 IS 'サブタイトル6';
COMMENT ON COLUMN dtb_products.sub_comment6 IS 'サブコメント6';
COMMENT ON COLUMN dtb_products.sub_image6 IS 'サブ画像6';
COMMENT ON COLUMN dtb_products.sub_large_image6 IS 'サブ拡大画像6';
COMMENT ON COLUMN dtb_products.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_products.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_products.create_date IS '作成日時';
COMMENT ON COLUMN dtb_products.update_date IS '更新日時';
COMMENT ON COLUMN dtb_products.deliv_date_id IS '発送日目安';

COMMENT ON TABLE mtb_delivery_date IS '商品発送日';
COMMENT ON COLUMN mtb_delivery_date.id IS 'ID';
COMMENT ON COLUMN mtb_delivery_date.name IS '名称';
COMMENT ON COLUMN mtb_delivery_date.rank IS '表示順';

COMMENT ON TABLE mtb_product_type IS '商品種別マスタ';
COMMENT ON COLUMN mtb_product_type.id IS 'ID';
COMMENT ON COLUMN mtb_product_type.name IS '名称';
COMMENT ON COLUMN mtb_product_type.rank IS '表示順';

COMMENT ON TABLE dtb_products_class IS '商品規格情報';
COMMENT ON COLUMN dtb_products_class.product_class_id IS '商品規格ID';
COMMENT ON COLUMN dtb_products_class.product_id IS '商品ID';
COMMENT ON COLUMN dtb_products_class.product_code IS '商品コード';
COMMENT ON COLUMN dtb_products_class.stock IS '在庫数';
COMMENT ON COLUMN dtb_products_class.stock_unlimited IS '在庫制限';
COMMENT ON COLUMN dtb_products_class.sale_limit IS '販売制限数';
COMMENT ON COLUMN dtb_products_class.price01 IS '価格';
COMMENT ON COLUMN dtb_products_class.price02 IS '特別価格';
COMMENT ON COLUMN dtb_products_class.deliv_fee IS '商品送料';
COMMENT ON COLUMN dtb_products_class.point_rate IS 'ポイント付与率';
COMMENT ON COLUMN dtb_products_class.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_products_class.create_date IS '作成日時';
COMMENT ON COLUMN dtb_products_class.update_date IS '更新日時';
COMMENT ON COLUMN dtb_products_class.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_products_class.classcategory_id1 IS '規格分類ID1';
COMMENT ON COLUMN dtb_products_class.classcategory_id2 IS '規格分類ID2';
COMMENT ON COLUMN dtb_products_class.product_type_id IS '商品種別ID';
COMMENT ON COLUMN dtb_products_class.down_filename IS 'ダウンロードファイル名';
COMMENT ON COLUMN dtb_products_class.down_realfilename IS 'ダウンロード実ファイル名';

COMMENT ON TABLE mtb_constants IS '定数マスタ';
COMMENT ON COLUMN mtb_constants.id IS 'ID';
COMMENT ON COLUMN mtb_constants.name IS '定数名';
COMMENT ON COLUMN mtb_constants.rank IS '表示順';
COMMENT ON COLUMN mtb_constants.remarks IS '定数コメント';

COMMENT ON TABLE dtb_baseinfo IS '店舗基本情報';
COMMENT ON COLUMN dtb_baseinfo.id IS '店舗基本情報ID';
COMMENT ON COLUMN dtb_baseinfo.company_name IS '会社名';
COMMENT ON COLUMN dtb_baseinfo.company_kana IS '会社名(カナ)';
COMMENT ON COLUMN dtb_baseinfo.zip01 IS '郵便番号(4桁)';
COMMENT ON COLUMN dtb_baseinfo.zip02 IS '郵便番号(3桁)';
COMMENT ON COLUMN dtb_baseinfo.zipcode IS '【2.13】郵便番号(海外対応)';
COMMENT ON COLUMN dtb_baseinfo.country_id IS '【2.13】国ID';
COMMENT ON COLUMN dtb_baseinfo.pref IS '都道府県';
COMMENT ON COLUMN dtb_baseinfo.addr01 IS '住所1';
COMMENT ON COLUMN dtb_baseinfo.addr02 IS '住所2';
COMMENT ON COLUMN dtb_baseinfo.tel01 IS '電話番号(市外局番)';
COMMENT ON COLUMN dtb_baseinfo.tel02 IS '電話番号(市内局番)';
COMMENT ON COLUMN dtb_baseinfo.tel03 IS '電話番号(局番)';
COMMENT ON COLUMN dtb_baseinfo.fax01 IS 'FAX番号(市外局番)';
COMMENT ON COLUMN dtb_baseinfo.fax02 IS 'FAX番号(市内局番)';
COMMENT ON COLUMN dtb_baseinfo.fax03 IS 'FAX番号(局番)';
COMMENT ON COLUMN dtb_baseinfo.business_hour IS '営業時間';
COMMENT ON COLUMN dtb_baseinfo.law_company IS '販売業者(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_manager IS '販売責任者(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_zip01 IS '郵便番号4桁(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_zip02 IS '郵便番号3桁(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_zipcode IS '【2.13】郵便番号(海外対応)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_country_id IS '【2.13】国ID(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_pref IS '都道府県(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_addr01 IS '住所1(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_addr02 IS '住所2(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_tel01 IS '電話番号(市外局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_tel02 IS '電話番号(市内局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_tel03 IS '電話番号(局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_fax01 IS 'FAX番号(市外局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_fax02 IS 'FAX番号(市内局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_fax03 IS 'FAX番号(局番)(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_email IS 'メールアドレス(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_url IS 'URL(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term01 IS '商品代金以外の必要料金(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term02 IS '注文方法(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term03 IS '支払方法(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term04 IS '支払期限(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term05 IS '引き渡し時期(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term06 IS '返品・交換について(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term07 IS '予備1(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term08 IS '予備2(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term09 IS '予備3(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.law_term10 IS '予備4(特定商取引)';
COMMENT ON COLUMN dtb_baseinfo.email01 IS '受注情報受付メールアドレス';
COMMENT ON COLUMN dtb_baseinfo.email02 IS '問い合わせ受付メールアドレス';
COMMENT ON COLUMN dtb_baseinfo.email03 IS '送信エラー受付メールアドレス';
COMMENT ON COLUMN dtb_baseinfo.email04 IS 'メール送信元メールアドレス';
COMMENT ON COLUMN dtb_baseinfo.free_rule IS '送料・手数料無料条件(円以上)';
COMMENT ON COLUMN dtb_baseinfo.shop_name IS '店舗名';
COMMENT ON COLUMN dtb_baseinfo.shop_kana IS '店舗名(カナ)';
COMMENT ON COLUMN dtb_baseinfo.point_rate IS 'ポイント付与率';
COMMENT ON COLUMN dtb_baseinfo.welcome_point IS '会員登録時付与ポイント';
COMMENT ON COLUMN dtb_baseinfo.update_date IS '更新日時';
COMMENT ON COLUMN dtb_baseinfo.top_tpl IS 'トップページテンプレート';
COMMENT ON COLUMN dtb_baseinfo.product_tpl IS '商品一覧テンプレート';
COMMENT ON COLUMN dtb_baseinfo.detail_tpl IS '商品詳細テンプレート';
COMMENT ON COLUMN dtb_baseinfo.mypage_tpl IS 'Myページテンプレート';
COMMENT ON COLUMN dtb_baseinfo.good_traded IS '取扱商品';
COMMENT ON COLUMN dtb_baseinfo.message IS 'メッセージ';
COMMENT ON COLUMN dtb_baseinfo.regular_holiday_ids IS '定休日の曜日';
COMMENT ON COLUMN dtb_baseinfo.latitude IS '緯度';
COMMENT ON COLUMN dtb_baseinfo.longitude IS '経度';
COMMENT ON COLUMN dtb_baseinfo.downloadable_days IS 'ダウンロード可能日数';
COMMENT ON COLUMN dtb_baseinfo.downloadable_days_unlimited IS 'ダウンロード可能日数無制限フラグ';
COMMENT ON COLUMN dtb_baseinfo.shop_name_eng IS '店舗名(英語）';

COMMENT ON TABLE mtb_sex IS '性別マスタ';
COMMENT ON COLUMN mtb_sex.id IS 'ID';
COMMENT ON COLUMN mtb_sex.name IS '名称';
COMMENT ON COLUMN mtb_sex.rank IS '表示順';

COMMENT ON TABLE dtb_payment IS '支払方法情報';
COMMENT ON COLUMN dtb_payment.payment_id IS '支払方法ID';
COMMENT ON COLUMN dtb_payment.payment_method IS '支払方法';
COMMENT ON COLUMN dtb_payment.charge IS '手数料';
COMMENT ON COLUMN dtb_payment.rule_max IS '利用条件(円以上)';
COMMENT ON COLUMN dtb_payment.rank IS '表示順';
COMMENT ON COLUMN dtb_payment.note IS '備考';
COMMENT ON COLUMN dtb_payment.fix IS '固定:1　自由設定:2';
COMMENT ON COLUMN dtb_payment.status IS '状態';
COMMENT ON COLUMN dtb_payment.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_payment.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_payment.create_date IS '作成日時';
COMMENT ON COLUMN dtb_payment.update_date IS '更新日時';
COMMENT ON COLUMN dtb_payment.payment_image IS '支払方法ロゴ';
COMMENT ON COLUMN dtb_payment.upper_rule IS '利用条件(円以下)';
COMMENT ON COLUMN dtb_payment.charge_flg IS '手数料設定フラグ';
COMMENT ON COLUMN dtb_payment.rule_min IS '利用条件(円以上)の下限';
COMMENT ON COLUMN dtb_payment.upper_rule_max IS '利用条件(円以下)の上限';
COMMENT ON COLUMN dtb_payment.module_id IS '追加モジュールID';
COMMENT ON COLUMN dtb_payment.module_path IS '追加モジュールパス';
COMMENT ON COLUMN dtb_payment.memo01 IS '汎用項目1';
COMMENT ON COLUMN dtb_payment.memo02 IS '汎用項目2';
COMMENT ON COLUMN dtb_payment.memo03 IS '汎用項目3';
COMMENT ON COLUMN dtb_payment.memo04 IS '汎用項目4';
COMMENT ON COLUMN dtb_payment.memo05 IS '汎用項目5';
COMMENT ON COLUMN dtb_payment.memo06 IS '汎用項目6';
COMMENT ON COLUMN dtb_payment.memo07 IS '汎用項目7';
COMMENT ON COLUMN dtb_payment.memo08 IS '汎用項目8';
COMMENT ON COLUMN dtb_payment.memo09 IS '汎用項目9';
COMMENT ON COLUMN dtb_payment.memo10 IS '汎用項目10';

COMMENT ON TABLE dtb_payment_options IS '支払選択肢情報';
COMMENT ON COLUMN dtb_payment_options.payment_id IS '支払方法ID';
COMMENT ON COLUMN dtb_payment_options.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_payment_options.rank IS '表示順';

COMMENT ON TABLE dtb_news IS '新着情報';
COMMENT ON COLUMN dtb_news.news_id IS '新着情報ID';
COMMENT ON COLUMN dtb_news.news_date IS '新着情報日付';
COMMENT ON COLUMN dtb_news.rank IS '表示順';
COMMENT ON COLUMN dtb_news.news_title IS '新着情報タイトル';
COMMENT ON COLUMN dtb_news.news_comment IS '新着情報コメント';
COMMENT ON COLUMN dtb_news.news_url IS '新着情報URL';
COMMENT ON COLUMN dtb_news.news_select IS '不明（未使用？）';
COMMENT ON COLUMN dtb_news.link_method IS '別ウィンドウで開くフラグ';
COMMENT ON COLUMN dtb_news.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_news.create_date IS '作成日時';
COMMENT ON COLUMN dtb_news.update_date IS '更新日時';
COMMENT ON COLUMN dtb_news.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_wday IS '曜日';
COMMENT ON COLUMN mtb_wday.id IS 'ID';
COMMENT ON COLUMN mtb_wday.name IS '名称';
COMMENT ON COLUMN mtb_wday.rank IS '表示順';

COMMENT ON TABLE mtb_work IS '稼動状態';
COMMENT ON COLUMN mtb_work.id IS 'ID';
COMMENT ON COLUMN mtb_work.name IS '名称';
COMMENT ON COLUMN mtb_work.rank IS '表示順';

COMMENT ON TABLE mtb_device_type IS '端末種別';
COMMENT ON COLUMN mtb_device_type.id IS 'ID';
COMMENT ON COLUMN mtb_device_type.name IS '名称';
COMMENT ON COLUMN mtb_device_type.rank IS '表示順';

COMMENT ON TABLE mtb_permission IS '管理画面アクセス権限';
COMMENT ON COLUMN mtb_permission.id IS 'ID';
COMMENT ON COLUMN mtb_permission.name IS '名称';
COMMENT ON COLUMN mtb_permission.rank IS '表示順';

COMMENT ON TABLE dtb_member IS '管理画面メンバー情報';
COMMENT ON COLUMN dtb_member.member_id IS 'メンバーID';
COMMENT ON COLUMN dtb_member.name IS '名前';
COMMENT ON COLUMN dtb_member.department IS '部門';
COMMENT ON COLUMN dtb_member.login_id IS 'ログインID';
COMMENT ON COLUMN dtb_member.password IS 'パスワード';
COMMENT ON COLUMN dtb_member.authority IS '権限';
COMMENT ON COLUMN dtb_member.rank IS '表示順';
COMMENT ON COLUMN dtb_member.work IS '稼動フラグ';
COMMENT ON COLUMN dtb_member.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_member.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_member.update_date IS '更新日付';
COMMENT ON COLUMN dtb_member.create_date IS '作成日時';
COMMENT ON COLUMN dtb_member.login_date IS '最終ログイン日時';
COMMENT ON COLUMN dtb_member.salt IS '暗号化付与文字列';

COMMENT ON TABLE mtb_authority IS '管理者マスタ';
COMMENT ON COLUMN mtb_authority.id IS 'ID';
COMMENT ON COLUMN mtb_authority.name IS '名称';
COMMENT ON COLUMN mtb_authority.rank IS '表示順';

COMMENT ON TABLE mtb_job IS '職業マスタ';
COMMENT ON COLUMN mtb_job.id IS 'ID';
COMMENT ON COLUMN mtb_job.name IS '名称';
COMMENT ON COLUMN mtb_job.rank IS '表示順';

COMMENT ON TABLE dtb_classcategory IS '規格分類情報';
COMMENT ON COLUMN dtb_classcategory.classcategory_id IS '規格分類情報ID';
COMMENT ON COLUMN dtb_classcategory.class_id IS '規格ID';
COMMENT ON COLUMN dtb_classcategory.name IS '規格分類名';
COMMENT ON COLUMN dtb_classcategory.rank IS '表示順';
COMMENT ON COLUMN dtb_classcategory.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_classcategory.create_date IS '作成日時';
COMMENT ON COLUMN dtb_classcategory.update_date IS '更新日時';
COMMENT ON COLUMN dtb_classcategory.del_flg IS '削除フラグ';

COMMENT ON TABLE dtb_class IS '規格情報';
COMMENT ON COLUMN dtb_class.class_id IS '規格ID';
COMMENT ON COLUMN dtb_class.name IS '規格名';
COMMENT ON COLUMN dtb_class.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_class.create_date IS '作成日時';
COMMENT ON COLUMN dtb_class.update_date IS '更新日時';
COMMENT ON COLUMN dtb_class.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_class.rank IS '表示順';

COMMENT ON TABLE dtb_kiyaku IS '規約情報';
COMMENT ON COLUMN dtb_kiyaku.kiyaku_id IS '規約ID';
COMMENT ON COLUMN dtb_kiyaku.kiyaku_title IS '規約タイトル';
COMMENT ON COLUMN dtb_kiyaku.kiyaku_text IS '規約本文';
COMMENT ON COLUMN dtb_kiyaku.rank IS '表示順';
COMMENT ON COLUMN dtb_kiyaku.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_kiyaku.create_date IS '作成日時';
COMMENT ON COLUMN dtb_kiyaku.update_date IS '更新日時';
COMMENT ON COLUMN dtb_kiyaku.del_flg IS '削除フラグ';

COMMENT ON TABLE mtb_allowed_tag IS '許可タグ';
COMMENT ON COLUMN mtb_allowed_tag.id IS 'ID';
COMMENT ON COLUMN mtb_allowed_tag.name IS '名称';
COMMENT ON COLUMN mtb_allowed_tag.rank IS '表示順';

COMMENT ON TABLE mtb_taxrule IS '課税規則マスタ';
COMMENT ON COLUMN mtb_taxrule.id IS 'ID';
COMMENT ON COLUMN mtb_taxrule.name IS '名称';
COMMENT ON COLUMN mtb_taxrule.rank IS '表示順';

COMMENT ON TABLE dtb_delivfee IS '送料情報';
COMMENT ON COLUMN dtb_delivfee.fee_id IS '送料ID';
COMMENT ON COLUMN dtb_delivfee.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_delivfee.fee IS '送料';
COMMENT ON COLUMN dtb_delivfee.pref IS '都道府県名';

COMMENT ON TABLE mtb_zip IS '郵便番号';
COMMENT ON COLUMN mtb_zip.zip_id IS '郵便番号ID';
COMMENT ON COLUMN mtb_zip.zipcode IS '郵便番号(7桁)';
COMMENT ON COLUMN mtb_zip.state IS '都道府県';
COMMENT ON COLUMN mtb_zip.city IS '市区町村';
COMMENT ON COLUMN mtb_zip.town IS '町域';

COMMENT ON TABLE mtb_pref IS '都道府県マスタ';
COMMENT ON COLUMN mtb_pref.id IS 'ID';
COMMENT ON COLUMN mtb_pref.name IS '名称';
COMMENT ON COLUMN mtb_pref.rank IS '表示順';

COMMENT ON TABLE dtb_shipping IS '配送先情報';
COMMENT ON COLUMN dtb_shipping.shipping_id IS '配送先ID';
COMMENT ON COLUMN dtb_shipping.order_id IS '受注ID';
COMMENT ON COLUMN dtb_shipping.shipping_name01 IS '配送先名前(姓)';
COMMENT ON COLUMN dtb_shipping.shipping_name02 IS '配送先名前(名)';
COMMENT ON COLUMN dtb_shipping.shipping_kana01 IS '配送先カナ(姓)';
COMMENT ON COLUMN dtb_shipping.shipping_kana02 IS '配送先カナ(名)';
COMMENT ON COLUMN dtb_shipping.shipping_company_name IS '【2.13】配送先会社名';
COMMENT ON COLUMN dtb_shipping.shipping_tel01 IS '配送先電話番号(市外局番)';
COMMENT ON COLUMN dtb_shipping.shipping_tel02 IS '配送先電話番号(市内局番)';
COMMENT ON COLUMN dtb_shipping.shipping_tel03 IS '配送先電話番号(局番)';
COMMENT ON COLUMN dtb_shipping.shipping_fax01 IS '配送先FAX(市外局番)';
COMMENT ON COLUMN dtb_shipping.shipping_fax02 IS '配送先FAX(市内局番)';
COMMENT ON COLUMN dtb_shipping.shipping_fax03 IS '配送先FAX(局番)';
COMMENT ON COLUMN dtb_shipping.shipping_country_id IS '【2.13】配送先国ID';
COMMENT ON COLUMN dtb_shipping.shipping_pref IS '都道府県ID';
COMMENT ON COLUMN dtb_shipping.shipping_zip01 IS '配送先郵便番号(3桁)';
COMMENT ON COLUMN dtb_shipping.shipping_zip02 IS '配送先郵便番号(4桁)';
COMMENT ON COLUMN dtb_shipping.shipping_zipcode IS '【2.13】配送先郵便番号(海外対応)';
COMMENT ON COLUMN dtb_shipping.shipping_addr01 IS '配送先住所1';
COMMENT ON COLUMN dtb_shipping.shipping_addr02 IS '配送先住所2';
COMMENT ON COLUMN dtb_shipping.time_id IS '配送時間ID';
COMMENT ON COLUMN dtb_shipping.shipping_time IS '配送時間';
COMMENT ON COLUMN dtb_shipping.shipping_date IS '配達予定日';
COMMENT ON COLUMN dtb_shipping.shipping_commit_date IS '発送日時';
COMMENT ON COLUMN dtb_shipping.rank IS '表示順';
COMMENT ON COLUMN dtb_shipping.create_date IS '作成日時';
COMMENT ON COLUMN dtb_shipping.update_date IS '更新日時';
COMMENT ON COLUMN dtb_shipping.del_flg IS '削除フラグ';

COMMENT ON TABLE dtb_shipment_item IS '配送商品情報';
COMMENT ON COLUMN dtb_shipment_item.product_class_id IS '商品規格ID';
COMMENT ON COLUMN dtb_shipment_item.shipping_id IS '配送先ID';
COMMENT ON COLUMN dtb_shipment_item.order_id IS '受注ID';
COMMENT ON COLUMN dtb_shipment_item.product_name IS '商品名';
COMMENT ON COLUMN dtb_shipment_item.product_code IS '商品コード';
COMMENT ON COLUMN dtb_shipment_item.classcategory_name1 IS '商品規格名1';
COMMENT ON COLUMN dtb_shipment_item.classcategory_name2 IS '商品規格名2';
COMMENT ON COLUMN dtb_shipment_item.price IS '価格';
COMMENT ON COLUMN dtb_shipment_item.quantity IS '個数';

COMMENT ON TABLE dtb_delivtime IS '配送時間情報';
COMMENT ON COLUMN dtb_delivtime.time_id IS '配送時間ID';
COMMENT ON COLUMN dtb_delivtime.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_delivtime.deliv_time IS '配送時間';

COMMENT ON TABLE dtb_deliv IS '配送業者情報';
COMMENT ON COLUMN dtb_deliv.deliv_id IS '配送業者ID';
COMMENT ON COLUMN dtb_deliv.product_type_id IS '商品種別ID';
COMMENT ON COLUMN dtb_deliv.name IS '配送業者名';
COMMENT ON COLUMN dtb_deliv.service_name IS '配送サービス名';
COMMENT ON COLUMN dtb_deliv.remark IS '説明';
COMMENT ON COLUMN dtb_deliv.confirm_url IS '伝票確認URL';
COMMENT ON COLUMN dtb_deliv.rank IS '表示順';
COMMENT ON COLUMN dtb_deliv.status IS '状態';
COMMENT ON COLUMN dtb_deliv.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_deliv.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_deliv.create_date IS '作成日時';
COMMENT ON COLUMN dtb_deliv.update_date IS '更新日時';

COMMENT ON TABLE dtb_recommend_products IS '関連商品情報';
COMMENT ON COLUMN dtb_recommend_products.recommend_product_id IS '関連商品ID';
COMMENT ON COLUMN dtb_recommend_products.product_id IS '商品ID';
COMMENT ON COLUMN dtb_recommend_products.rank IS '表示順';
COMMENT ON COLUMN dtb_recommend_products.comment IS 'コメント';
COMMENT ON COLUMN dtb_recommend_products.status IS '状態';
COMMENT ON COLUMN dtb_recommend_products.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_recommend_products.create_date IS '作成日時';
COMMENT ON COLUMN dtb_recommend_products.update_date IS '更新日時';

COMMENT ON TABLE dtb_send_customer IS '顧客メール送信履歴';
COMMENT ON COLUMN dtb_send_customer.send_id IS '送信ID';
COMMENT ON COLUMN dtb_send_customer.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_send_customer.email IS 'メールアドレス';
COMMENT ON COLUMN dtb_send_customer.name IS '名前';
COMMENT ON COLUMN dtb_send_customer.send_flag IS '送信フラグ';

COMMENT ON TABLE dtb_customer IS '顧客情報';
COMMENT ON COLUMN dtb_customer.customer_id IS '顧客ID';
COMMENT ON COLUMN dtb_customer.name01 IS '姓';
COMMENT ON COLUMN dtb_customer.name02 IS '名';
COMMENT ON COLUMN dtb_customer.kana01 IS '姓(カナ)';
COMMENT ON COLUMN dtb_customer.kana02 IS '名(カナ)';
COMMENT ON COLUMN dtb_customer.company_name IS '【2.13】国名';
COMMENT ON COLUMN dtb_customer.zip01 IS '郵便番号(4桁)';
COMMENT ON COLUMN dtb_customer.zip02 IS '郵便番号(3桁)';
COMMENT ON COLUMN dtb_customer.zipcode IS '【2.13】郵便番号(海外対応)';
COMMENT ON COLUMN dtb_customer.country_id IS '【2.13】国ID';
COMMENT ON COLUMN dtb_customer.pref IS '都道府県';
COMMENT ON COLUMN dtb_customer.addr01 IS '市区町村';
COMMENT ON COLUMN dtb_customer.addr02 IS '番地等';
COMMENT ON COLUMN dtb_customer.email IS 'メールアドレス';
COMMENT ON COLUMN dtb_customer.email_mobile IS '携帯メールアドレス';
COMMENT ON COLUMN dtb_customer.tel01 IS '電話(市外局番)';
COMMENT ON COLUMN dtb_customer.tel02 IS '電話(市内局番)';
COMMENT ON COLUMN dtb_customer.tel03 IS '電話(局番)';
COMMENT ON COLUMN dtb_customer.fax01 IS 'FAX(市外局番)';
COMMENT ON COLUMN dtb_customer.fax02 IS 'FAX(市内局番)';
COMMENT ON COLUMN dtb_customer.fax03 IS 'FAX(局番)';
COMMENT ON COLUMN dtb_customer.sex IS '性別';
COMMENT ON COLUMN dtb_customer.job IS '職業';
COMMENT ON COLUMN dtb_customer.birth IS '生年月日';
COMMENT ON COLUMN dtb_customer.password IS 'パスワード';
COMMENT ON COLUMN dtb_customer.reminder IS 'パスワードの質問';
COMMENT ON COLUMN dtb_customer.reminder_answer IS 'パスワードの質問の答え';
COMMENT ON COLUMN dtb_customer.salt IS '暗号化付与文字列';
COMMENT ON COLUMN dtb_customer.secret_key IS '暗号化キー';
COMMENT ON COLUMN dtb_customer.first_buy_date IS '初回購入日時';
COMMENT ON COLUMN dtb_customer.last_buy_date IS '最終購入日時';
COMMENT ON COLUMN dtb_customer.buy_times IS '購入回数';
COMMENT ON COLUMN dtb_customer.buy_total IS '購入累計金額';
COMMENT ON COLUMN dtb_customer.point IS '保持ポイント';
COMMENT ON COLUMN dtb_customer.note IS '備考';
COMMENT ON COLUMN dtb_customer.status IS '状態';
COMMENT ON COLUMN dtb_customer.create_date IS '作成日時';
COMMENT ON COLUMN dtb_customer.update_date IS '更新日時';
COMMENT ON COLUMN dtb_customer.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_customer.mobile_phone_id IS '携帯端末ID';
COMMENT ON COLUMN dtb_customer.mailmaga_flg IS 'メールマガジン種別フラグ';

COMMENT ON TABLE dtb_maker IS 'メーカー';
COMMENT ON COLUMN dtb_maker.maker_id IS 'メーカーID';
COMMENT ON COLUMN dtb_maker.name IS 'メーカー名';
COMMENT ON COLUMN dtb_maker.rank IS '表示順';
COMMENT ON COLUMN dtb_maker.creator_id IS '作成者ID';
COMMENT ON COLUMN dtb_maker.create_date IS '作成日時';
COMMENT ON COLUMN dtb_maker.update_date IS '更新日時';
COMMENT ON COLUMN dtb_maker.del_flg IS '削除フラグ';

COMMENT ON TABLE dtb_maker_count IS 'メーカーカウント';
COMMENT ON COLUMN dtb_maker_count.maker_id IS 'メーカーID';
COMMENT ON COLUMN dtb_maker_count.product_count IS '登録商品数';
COMMENT ON COLUMN dtb_maker_count.create_date IS '作成日時';

COMMENT ON TABLE mtb_auth_excludes IS '管理画面認証除外';
COMMENT ON COLUMN mtb_auth_excludes.id IS 'ID';
COMMENT ON COLUMN mtb_auth_excludes.name IS '名称';
COMMENT ON COLUMN mtb_auth_excludes.rank IS '表示順';

COMMENT ON TABLE mtb_customer_status IS '顧客ステータス';
COMMENT ON COLUMN mtb_customer_status.id IS 'ID';
COMMENT ON COLUMN mtb_customer_status.name IS '名称';
COMMENT ON COLUMN mtb_customer_status.rank IS '表示順';

COMMENT ON TABLE mtb_customer_order_status IS '顧客表示用受注ステータス';
COMMENT ON COLUMN mtb_customer_order_status.id IS 'ID';
COMMENT ON COLUMN mtb_customer_order_status.name IS '名称';
COMMENT ON COLUMN mtb_customer_order_status.rank IS '表示順';

COMMENT ON TABLE dtb_bkup IS 'バックアップ';
COMMENT ON COLUMN dtb_bkup.bkup_name IS 'バックアップ名';
COMMENT ON COLUMN dtb_bkup.bkup_memo IS 'バックアップメモ';
COMMENT ON COLUMN dtb_bkup.create_date IS '作成日時';

COMMENT ON TABLE dtb_plugin_hookpoint IS 'プラグインフックポイント';
COMMENT ON COLUMN dtb_plugin_hookpoint.plugin_hookpoint_id IS 'プラグインフックポイントID';
COMMENT ON COLUMN dtb_plugin_hookpoint.plugin_id IS 'プラグインID';
COMMENT ON COLUMN dtb_plugin_hookpoint.hook_point IS 'フックポイント';
COMMENT ON COLUMN dtb_plugin_hookpoint.callback IS 'コールバック関数';
COMMENT ON COLUMN dtb_plugin_hookpoint.use_flg IS '【2.13】利用フラグ';
COMMENT ON COLUMN dtb_plugin_hookpoint.create_date IS '作成日時';
COMMENT ON COLUMN dtb_plugin_hookpoint.update_date IS '更新日時';

COMMENT ON TABLE dtb_index_list IS 'インデックス一覧';
COMMENT ON COLUMN dtb_index_list.table_name IS 'テーブル名';
COMMENT ON COLUMN dtb_index_list.column_name IS 'カラム名';
COMMENT ON COLUMN dtb_index_list.recommend_flg IS 'レコメンドフラグ';
COMMENT ON COLUMN dtb_index_list.recommend_comment IS 'レコメンドフラグコメント';

COMMENT ON TABLE dtb_api_config IS 'API設定';
COMMENT ON COLUMN dtb_api_config.api_config_id IS 'API設定ID';
COMMENT ON COLUMN dtb_api_config.operation_name IS 'オペレーション名';
COMMENT ON COLUMN dtb_api_config.operation_description IS '説明';
COMMENT ON COLUMN dtb_api_config.auth_types IS '認証タイプ';
COMMENT ON COLUMN dtb_api_config.enable IS '有効フラグ';
COMMENT ON COLUMN dtb_api_config.is_log IS 'ログ出力フラグ';
COMMENT ON COLUMN dtb_api_config.sub_data IS '追加の設定情報';
COMMENT ON COLUMN dtb_api_config.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_api_config.create_date IS '作成日時';
COMMENT ON COLUMN dtb_api_config.update_date IS '更新日時';

COMMENT ON TABLE dtb_api_account IS 'APIアカウント';
COMMENT ON COLUMN dtb_api_account.api_account_id IS 'APIアカウントID';
COMMENT ON COLUMN dtb_api_account.api_access_key IS 'アクセスキー';
COMMENT ON COLUMN dtb_api_account.api_secret_key IS 'シークレットキー';
COMMENT ON COLUMN dtb_api_account.enable IS '有効';
COMMENT ON COLUMN dtb_api_account.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_api_account.create_date IS '作成日時';
COMMENT ON COLUMN dtb_api_account.update_date IS '更新日時';

COMMENT ON TABLE dtb_tax_rule IS '【2.13】消費税ルール';
COMMENT ON COLUMN dtb_tax_rule.tax_rule_id IS '税率ID';
COMMENT ON COLUMN dtb_tax_rule.country_id IS '国ID';
COMMENT ON COLUMN dtb_tax_rule.pref_id IS '地域ID';
COMMENT ON COLUMN dtb_tax_rule.product_id IS '商品ID';
COMMENT ON COLUMN dtb_tax_rule.product_class_id IS '商品規格ID';
COMMENT ON COLUMN dtb_tax_rule.calc_rule IS '課税規則（四捨五入、切り上げ、切り捨て）';
COMMENT ON COLUMN dtb_tax_rule.tax_rate IS '消費税率';
COMMENT ON COLUMN dtb_tax_rule.tax_adjust IS '固定金額';
COMMENT ON COLUMN dtb_tax_rule.apply_date IS '適用日';
COMMENT ON COLUMN dtb_tax_rule.member_id IS '作成者ID';
COMMENT ON COLUMN dtb_tax_rule.del_flg IS '削除フラグ';
COMMENT ON COLUMN dtb_tax_rule.create_date IS '作成日時';
COMMENT ON COLUMN dtb_tax_rule.update_date IS '更新日時';

COMMENT ON TABLE mtb_country IS '【2.13】国マスタ';
COMMENT ON COLUMN mtb_country.id IS 'ID';
COMMENT ON COLUMN mtb_country.name IS '名称';
COMMENT ON COLUMN mtb_country.rank IS '表示順';
