<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


namespace Eccube\Repository\Master;

use Doctrine\ORM\EntityRepository;

/**
 * TagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TagRepository extends EntityRepository
{
    public function findOrCreateByTagName($tag_name)
    {
        $Tag = $this->findOneBy(array('name' => $tag_name));

        if (is_null($Tag)) {
            $RankTop = $this->findOneBy(array(), array('rank' => 'DESC'));
            $rank = 0;
            if (!is_null($RankTop)) {
                $rank = $RankTop->getRank();
            }

            $Tag = new \Eccube\Entity\Master\Tag();
            $Tag
                ->setName($tag_name)
                ->setRank($rank + 1);
        }

        return $Tag;
    }
}
