<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) 2000-2015 LOCKON CO.,LTD. All Rights Reserved.
 *
 * http://www.lockon.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


namespace Eccube\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ClasscategoryRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ClassCategoryRepository extends EntityRepository
{
    /**
     * 規格カテゴリの一覧を取得します.
     *
     * @param \Eccube\Entity\ClassName $ClassName 検索対象の規格名オブジェクト. 指定しない場合は、すべての規格を対象に取得します.
     * @return array 規格カテゴリの配列
     */
    public function getList(\Eccube\Entity\ClassName $ClassName = null)
    {
        $qb = $this->createQueryBuilder('cc')
            ->orderBy('cc.rank', 'DESC'); // TODO ClassName ごとにソートした方が良いかも
        if ($ClassName) {
            $qb->where('cc.ClassName = :ClassName')->setParameter('ClassName', $ClassName);
        }
        $ClassCategories = $qb->getQuery()
            ->getResult();

        return $ClassCategories;
    }

    /**
     * 規格カテゴリの順位を1上げる.
     *
     * @param \Eccube\Entity\ClassCategory $ClassCategory
     * @return boolean 成功した場合 true
     */
    public function up(\Eccube\Entity\ClassCategory $ClassCategory)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $ClassCategory->getRank();
            $ClassName = $ClassCategory->getClassName();

            $ClassCategory2 = $this->findOneBy(array('rank' => $rank + 1, 'ClassName' => $ClassName));
            if (!$ClassCategory2) {
                throw new \Exception();
            }
            $ClassCategory2->setRank($rank);
            $em->persist($ClassCategory);

            // ClassCategory更新
            $ClassCategory->setRank($rank + 1);

            $em->persist($ClassCategory);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }

    /**
     * 規格カテゴリの順位を1下げる.
     *
     * @param  \Eccube\Entity\ClassCategory $ClassCategory
     * @return boolean 成功した場合 true
     */
    public function down(\Eccube\Entity\ClassCategory $ClassCategory)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $ClassCategory->getRank();
            $ClassName = $ClassCategory->getClassName();

            //
            $ClassCategory2 = $this->findOneBy(array('rank' => $rank - 1, 'ClassName' => $ClassName));
            if (!$ClassCategory2) {
                throw new \Exception();
            }
            $ClassCategory2->setRank($rank);
            $em->persist($ClassCategory);

            // ClassCategory更新
            $ClassCategory->setRank($rank - 1);

            $em->persist($ClassCategory);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }

    /**
     * 規格カテゴリを保存する.
     *
     * @param  \Eccube\Entity\ClassCategory $ClassCategory
     * @return boolean 成功した場合 true
     */
    public function save(\Eccube\Entity\ClassCategory $ClassCategory)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            if (!$ClassCategory->getId()) {
                $ClassName = $ClassCategory->getClassName();
                $rank = $this->createQueryBuilder('cc')
                    ->select('MAX(cc.rank)')
                    ->where('cc.ClassName = :ClassName')->setParameter('ClassName', $ClassName)
                    ->getQuery()
                    ->getSingleScalarResult();
                if (!$rank) {
                    $rank = 0;
                }
                $ClassCategory->setRank($rank + 1);
                $ClassCategory->setDelFlg(0);
            }

            $em->persist($ClassCategory);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }

    /**
     * 規格カテゴリを削除する.
     *
     * @param \Eccube\Entity\ClassCategory $ClassCategory
     * @return boolean 成功した場合 true
     */
    public function delete(\Eccube\Entity\ClassCategory $ClassCategory)
    {
        $em = $this->getEntityManager();
        $em->getConnection()->beginTransaction();
        try {
            $rank = $ClassCategory->getRank();
            $ClassName = $ClassCategory->getClassName();

            $em->createQueryBuilder()
                ->update('Eccube\Entity\ClassCategory', 'cc')
                ->set('cc.rank', 'cc.rank - 1')
                ->where('cc.rank > :rank AND cc.ClassName = :ClassName')
                ->setParameter('rank', $rank)
                ->setParameter('ClassName', $ClassName)
                ->getQuery()
                ->execute();

            $ClassCategory->setDelFlg(1);
            $em->persist($ClassCategory);
            $em->flush();

            $em->getConnection()->commit();
        } catch (\Exception $e) {
            $em->getConnection()->rollback();

            return false;
        }

        return true;
    }
}
