<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) 2000-2015 LOCKON CO.,LTD. All Rights Reserved.
 *
 * http://www.lockon.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


namespace Eccube\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\QueryBuilder;
use Eccube\Common\Constant;

/**
 * CustomerFavoriteProductRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CustomerFavoriteProductRepository extends EntityRepository
{
    /**
     * @param \Eccube\Entity\Customer $Customer
     * @param \Eccube\Entity\Product  $Product
     */
    public function addFavorite(\Eccube\Entity\Customer $Customer, \Eccube\Entity\Product $Product)
    {
        if ($this->isFavorite($Customer, $Product)) {
            return;
        } else {
            $CustomerFavoriteProduct = new \Eccube\Entity\CustomerFavoriteProduct();
            $CustomerFavoriteProduct->setCustomer($Customer);
            $CustomerFavoriteProduct->setProduct($Product);
            $CustomerFavoriteProduct->setDelFlg(Constant::DISABLED);

            $em = $this->getEntityManager();
            $em->persist($CustomerFavoriteProduct);
            $em->flush();
        }
    }

    /**
     * @param  \Eccube\Entity\Customer $Customer
     * @param  \Eccube\Entity\Product  $Product
     * @return bool
     */
    public function isFavorite(\Eccube\Entity\Customer $Customer, \Eccube\Entity\Product $Product)
    {
        $qb = $this->createQueryBuilder('cf')
            ->select('COUNT(cf.Product)')
            ->andWhere('cf.Customer = :Customer AND cf.Product = :Product')
            ->setParameters(array(
                'Customer' => $Customer,
                'Product' => $Product,
            ));
        $count = $qb
            ->getQuery()
            ->getSingleScalarResult();

        return $count > 0;
    }

    /**
     * @param  \Eccube\Entity\Customer $Customer
     * @param  \Eccube\Entity\Product  $Product
     * @return bool
     */
    public function deleteFavorite(\Eccube\Entity\Customer $Customer, \Eccube\Entity\Product $Product)
    {
        $qb = $this->createQueryBuilder('cf')
            ->andWhere('cf.Customer = :Customer AND cf.Product = :Product')
            ->setParameters(array(
                'Customer' => $Customer,
                'Product' => $Product,
            ));

        try {
            $CustomerFavoriteProduct = $qb
                ->getQuery()
                ->getSingleResult();
        } catch (\Exception $e) {
            return false;
        }

        $em = $this->getEntityManager();
        $em->remove($CustomerFavoriteProduct);
        $em->flush();

        return true;
    }

    /**
     * @param  \Eccube\Entity\Customer $Customer
     * @return QueryBuilder
     */
    public function getQueryBuilderByCustomer(\Eccube\Entity\Customer $Customer)
    {
        $qb = $this->createQueryBuilder('cfp')
            ->select('cfp, p')
            ->innerJoin('cfp.Product', 'p')
            ->where('cfp.Customer = :Customer AND p.Status = 1')
            ->setParameter('Customer', $Customer);

        // Order By
        $qb->addOrderBy('cfp.create_date', 'DESC');

        return $qb;
    }
}
